﻿/*
USAGE: 
	#include "gameProgram/loadGameFile.as"
	loadGameFile( "saves\\myFile.xml" );
*/
function loadGameFile( relativeFilePath ){
	#include "functions/VOW.as"
	#include "functions/VOW/loadFile.as"
	#include "gameProgram/loadGameXml.as"
	var vow = VOW.make();
	
	
	// try placing an internal version of the level
	var getSavedGameXml = function( internal_xml ){
		ROOT.internalSavedGame.removeMovieClip();
		ROOT.internalSavedGame._name = null;
		
		loadGameXml( internal_xml )
		.then( vow.keep );
	}// getSavedGameXml()
	
	ROOT.internalSavedGame.removeMovieClip();
	ROOT.internalSavedGame._name = null;
	ROOT.attachMovie( relativeFilePath, "internalSavedGame", 14, {onLoad:getSavedGameXml});
	
	
	// if:  internal load fails
	if( !ROOT.internalSavedGame ){
		// load an external version
		loadFile( relativeFilePath )
		.then( function(file_str){
			return loadGameXml( file_str )
		} );
	}// if:  internal load fails
	else{
		return vow;
	}
}// loadGameFile()